<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$user = $_SESSION['user'] ?? ['name' => 'Agent'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Reports - CyberWall CallCenter</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body{background:#f8f9fa;font-family:"Segoe UI",sans-serif;}
    .sidebar{position:fixed;top:0;left:0;width:240px;height:100vh;background:#1f2d3a;color:#fff;}
    .sidebar .nav-link{color:#cfd8dc;padding:10px 20px;}
    .sidebar .nav-link.active,.sidebar .nav-link:hover{background:#273746;color:#fff;}
    .main{margin-left:240px;padding:2rem;}
  </style>
</head>
<body>
<div class="sidebar">
  <div class="p-3">
    <h4><i class="bi bi-telephone-fill me-2"></i>CyberWall</h4>
    <nav class="nav flex-column mt-4">
      <a class="nav-link <?= ($page ?? '') === 'dashboard' ? 'active' : '' ?>" href="index.php?page=dashboard">
  <i class="bi bi-speedometer2 me-2"></i> Dashboard
</a>
<a class="nav-link <?= ($page ?? '') === 'customers' ? 'active' : '' ?>" href="index.php?page=customers">
  <i class="bi bi-people me-2"></i> Customers
</a>
<a class="nav-link <?= ($page ?? '') === 'calls' ? 'active' : '' ?>" href="index.php?page=calls">
  <i class="bi bi-telephone me-2"></i> Calls
</a>
<a class="nav-link <?= ($page ?? '') === 'tickets' ? 'active' : '' ?>" href="index.php?page=tickets">
  <i class="bi bi-ticket-detailed me-2"></i> Tickets
</a>
<a class="nav-link <?= ($page ?? '') === 'reports' ? 'active' : '' ?>" href="index.php?page=reports">
  <i class="bi bi-bar-chart-line me-2"></i> Reports
</a>

    </nav>
  </div>
  <div class="p-3">
    <a href="login.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right me-2"></i>Logout</a>
  </div>
</div>

<div class="main">
  <div class="d-flex justify-content-between mb-4">
    <h3 class="fw-bold">Performance Reports</h3>
    <span class="text-muted"><?= htmlspecialchars($user['name']) ?> | Agent</span>
  </div>

  <div class="row g-4">
    <div class="col-md-6">
      <div class="card p-3">
        <h5 class="text-primary"><i class="bi bi-bar-chart me-2"></i> Calls per Day</h5>
        <canvas id="callsChart"></canvas>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card p-3">
        <h5 class="text-success"><i class="bi bi-pie-chart me-2"></i> Ticket Status</h5>
        <canvas id="ticketsChart"></canvas>
      </div>
    </div>
  </div>
</div>

<script>
const ctx1 = document.getElementById('callsChart');
new Chart(ctx1, {
  type: 'line',
  data: {
    labels: ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
    datasets: [{label: 'Calls', data: [34,42,28,60,50,30,22], borderColor:'#007bff',fill:false}]
  }
});

const ctx2 = document.getElementById('ticketsChart');
new Chart(ctx2, {
  type: 'doughnut',
  data: {
    labels: ['Open','In Progress','Resolved'],
    datasets: [{data:[6,3,12],backgroundColor:['#ffc107','#17a2b8','#28a745']}]
  }
});
</script>
</body>
</html>
