// public/js/sip.js
console.log("🚀 SIP.js starting...");

import {
  UserAgent,
  Registerer,
  Invitation,
  SessionState
} from "https://cdnjs.cloudflare.com/ajax/libs/sip.js/0.20.0/sip.min.js";

// Configuration
const sipServer = "wss://pbx.cyberwallvoip.com:8089/ws";
const sipUri = UserAgent.makeURI("sip:5391005@pbx.cyberwallvoip.com");
const sipUser = "5391005";
const sipPass = "5hfmgdqqaJwe4euBFXEf5cgUf";
const displayName = "R";

const userAgent = new UserAgent({
  uri: sipUri,
  transportOptions: { server: sipServer },
  authorizationUsername: sipUser,
  authorizationPassword: sipPass,
  displayName,
  sessionDescriptionHandlerFactoryOptions: {
    peerConnectionConfiguration: {
      iceServers: [{ urls: "stun:stun.l.google.com:19302" }]
    }
  }
});

let registerer;
const statusEl = document.getElementById("sipStatus");
const btnRegister = document.getElementById("btnRegister");
const btnUnregister = document.getElementById("btnUnregister");

// --- Helper: update Agent DB ---
async function updateAgentStatus(newStatus) {
  try {
    await fetch("sip_status_update.php", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: "status=" + encodeURIComponent(newStatus),
    });
  } catch (err) {
    console.warn("⚠️ Could not sync agent status:", err);
  }
}

// --- UI update ---
function updateStatus(label, color) {
  statusEl.textContent = label;
  statusEl.classList.remove("text-secondary", "text-success", "text-danger", "text-warning");
  statusEl.classList.add("text-" + color);
  btnRegister.disabled = (color === "success");
  btnUnregister.disabled = (color !== "success");
}

// --- Register ---
async function register() {
  try {
    await userAgent.start();
    registerer = new sipjs.Registerer(userAgent);
    await registerer.register();
    updateStatus("🟢 Registered", "success");
    console.log("✅ SIP Registered");
    updateAgentStatus("available");
  } catch (e) {
    console.error("❌ Registration failed:", e);
    updateStatus("🔴 Registration failed", "danger");
    updateAgentStatus("offline");
  }
}

// --- Unregister ---
async function unregister() {
  try {
    if (registerer) await registerer.unregister();
    await userAgent.stop();
    updateStatus("⚫ Disconnected", "secondary");
    updateAgentStatus("offline");
  } catch (e) {
    console.error("❌ Unregister error:", e);
  }
}

// --- Incoming call ---
userAgent.delegate = {
  onInvite(invitation) {
    console.log("📞 Incoming call from:", invitation.remoteIdentity.uri);
    updateStatus("🔵 Incoming call...", "warning");
    updateAgentStatus("busy");

    invitation.accept().then(() => {
      console.log("✅ Call accepted");
      updateStatus("🟢 On Call", "success");
      updateAgentStatus("busy");

      invitation.stateChange.addListener((state) => {
        if (state === SessionState.Terminated) {
          console.log("📴 Call ended");
          updateStatus("🟢 Registered", "success");
          updateAgentStatus("available");
        }
      });
    });
  },
};

// --- Buttons ---
btnRegister?.addEventListener("click", register);
btnUnregister?.addEventListener("click", unregister);

// --- Auto connect ---
window.addEventListener("load", register);
