<?php
require_once __DIR__ . '/../app/Config/config.php';
require_once __DIR__ . '/../app/Core/Database.php';
session_start();

$user = $_SESSION['user'] ?? null;
if (empty($user['id'])) {
  http_response_code(403);
  echo json_encode(['success' => false, 'message' => 'Not logged in']);
  exit;
}

$pdo = Database::db();
$status = $_POST['status'] ?? '';

$allowed = ['available', 'busy', 'offline'];
if (!in_array($status, $allowed)) {
  echo json_encode(['success' => false, 'message' => 'Invalid status']);
  exit;
}

$stmt = $pdo->prepare("
  INSERT INTO agent_status (user_id, status, last_status_change)
  VALUES (?, ?, NOW())
  ON DUPLICATE KEY UPDATE status = VALUES(status), last_status_change = NOW()
");
$stmt->execute([$user['id'], $status]);

echo json_encode(['success' => true, 'status' => $status]);
